/**
  *
  * Beschreibung: Grafik mit Gitternetz mit Canvas-Komponente
  *                mit Tastatursteuerung
  * @version 1.1 vom 17.09.2006
  * @author
  */
  
import java.util.*;
import java.awt.*;
import javax.swing.*;
//und ein Import, um den MouseListener verwenden zu knnen
import java.awt.event.*; 
 
public class AutoCanvas extends Canvas implements MouseListener{ //MouseListener muss implementiert werden  
  
  // Anfang Attribute
  private static final int kbreite = 20;                //Gre des Gitternetzes
  private static final int xmax = 20;
  private static final int ymax = 20;
  private String bildname;
  private Image grafik;
  private int xPos;
  private int yPos=5;
  
  // Ende Attribute
  
  // Anfang Methoden
  public AutoCanvas() {       //Konstruktor
    super(null);              //bernahme des Konstruktors von der Oberklasse Canvas
    addMouseListener(this);//Das Gitternetz hrt sich selbst zu und reagiert auf Tastendruck 
    addMouseListener(new MouseAdapter() {
      public void mousePressed(MouseEvent e) {
        requestFocus();
      }
    });
    
  }
  //Zeichnen des Gitternetzes
  public void paint(Graphics g) {                      
    g.setColor(Color.white);
    g.fillRect(0, 0, xmax*kbreite, ymax*kbreite);
    
    g.setColor(Color.black);
    for (int i = 0; i <= xmax; i++) {
      g.drawLine(i * kbreite, 0, i * kbreite, ymax * kbreite);
    }
    for (int j = 0; j <= ymax; j++) {
      g.drawLine(0, j * kbreite, xmax * kbreite, j * kbreite);
    }
  }
  //Zeichnen des Autos
  private void zeichneAuto(Graphics g, int x, int y,Image bild) {
    g.drawImage(bild, x * kbreite + 1, y * kbreite + 1,
    kbreite - 1, kbreite - 1, this);
  }
  public void zeichne(int x, int y) {
    Graphics g = getGraphics();
    bildname = "auto1.gif";
    grafik = new ImageIcon(getClass().getResource(bildname)).getImage();
    zeichneAuto(g,x,y,grafik);
  }
  //METHODEN ZUR ERKENNUNG DES MOUSE-KLICKS
  
  //wird ausgefhrt, wenn die Maustaste ber einer Komponente gedrckt wurde
  public void mousePressed(MouseEvent e) {
    xPos = e.getX()/kbreite; //allerdings funktioniert es noch nicht so, die xPosition ist noch nicht auf das Gitternetz abgestellt 
    yPos = e.getY()/kbreite;
    zeichne(xPos,yPos);
  }
  //wird ausgefhrt, wenn die Maus vom Benutzer geklickt wurde
  public void mouseClicked(MouseEvent e) {}
  //wird ausgefhrt, wenn die Maustaste ber einer Komponente losgelassen wurde.
  public void mouseReleased(MouseEvent e) {}
  //Wird ausgefhrt, wenn die Maus eine Komponente verlsst
  public void mouseExited(MouseEvent e){}
  //wird ausgefhrt, wenn die Maus eine Komponente betritt
  public void mouseEntered(MouseEvent e){}
  
  public void setXPos(int xPos) {
    this.xPos = xPos;
  }

  
  public void setYPos(int yPos) {
    this.yPos = yPos;
  }
  
  public int getXPos() {
    return xPos;
  }

  // Ende Methoden
} //Ende der Klasse