import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  *
  * Beschreibung
  *
  * @version 1.0 vom 23.11.2014
  * @author 
  */

public class GitternetzMitAuto extends JFrame {
  // Anfang Attribute
  private JButton jBuStart = new JButton();
  private AutoCanvas flaeche = new AutoCanvas();
  private JButton jBuPosition = new JButton();
  // Ende Attribute
  
  public GitternetzMitAuto(String title) { 
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 513; 
    int frameHeight = 536;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    jBuStart.setBounds(80, 440, 145, 49);
    jBuStart.setText("starten");
    jBuStart.setMargin(new Insets(2, 2, 2, 2));
    jBuStart.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBuStart_ActionPerformed(evt);
      }
    });
    cp.add(jBuStart);
    flaeche.setBounds(0,0,401,401);
    cp.add(flaeche);
    jBuPosition.setBounds(248, 440, 225, 49);
    jBuPosition.setText("zeige Position (5,3)");
    jBuPosition.setMargin(new Insets(2, 2, 2, 2));
    jBuPosition.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBuPosition_ActionPerformed(evt);
      }
    });
    cp.add(jBuPosition);
    // Ende Komponenten
    
    setVisible(true);
  } // end of public GitternetzMitAuto
  
  // Anfang Methoden
  public int xRichtungbewegen(int aktuelleXPos, int zielXPos){
    //Richtung bestimmen
    int aenderungX;
    //Richtungsnderung in x-Richtung
    if (aktuelleXPos < zielXPos)
    aenderungX = 1;
    else if (aktuelleXPos > zielXPos)
    aenderungX = -1;
    else
    aenderungX = 0;       
    return aktuelleXPos+aenderungX;
  }
  public int yRichtungbewegen(int aktuelleYPos, int zielYPos){
    //Richtung bestimmen
    int aenderungY;
    //Richtungsnderung in y-Richtung
    if (aktuelleYPos < zielYPos)
    aenderungY = 1;
    else if (aktuelleYPos > zielYPos)
    aenderungY = -1;
    else
    aenderungY = 0;     
    return aktuelleYPos+aenderungY;
  }
  //Verlangsamung des simulierten Bewegungsvorgangs
  public void warten(int millisek) {
    try {
      Thread.sleep(millisek);
    } catch(Exception e) {
      
    } // end of try
  }
  
  public void jBuStart_ActionPerformed(ActionEvent evt) {
    
    //zufllig eine Anfangsposition bestimmen
    int xA = (int)(Math.random()*20);
    int yA = (int)(Math.random()*20);
    //zufllig eine Endposition bestimmen
    int xE = (int)(Math.random()*20);
    int yE = (int)(Math.random()*20);
    //aktuelle Position
    int xAkt = xA;
    int yAkt = yA;  
    flaeche.zeichne(xAkt,yAkt);  
    
    for (int i = 0;i<50 ;i++ ) {
      xAkt = xRichtungbewegen(xAkt, xE);
      yAkt = yRichtungbewegen(yAkt, yE);
      flaeche.zeichne(xAkt,yAkt);     
      warten(200);
    } // end of for
  } // end of jBuStart_ActionPerformed
  
  public void jBuPosition_ActionPerformed(ActionEvent evt) {
    flaeche.zeichne(5,3);
  } // end of jBuPosition_ActionPerformed

  // Ende Methoden
  
  public static void main(String[] args) {
    new GitternetzMitAuto("GitternetzMitAuto");
  } // end of main
  
} // end of class GitternetzMitAuto
