/**
  *
  * Beschreibung: Grafik mit Gitternetz mit Canvas-Komponente
  *                mit Tastatursteuerung
  * @version 1.1 vom 17.09.2006
  * @author
  */
  
import java.util.*;
import java.awt.*;
import javax.swing.*;
//und ein Import, um den KeyListener verwenden zu knnen
import java.awt.event.*; 
 
public class AutoCanvas extends Canvas implements KeyListener{ //KeyListener muss implementiert werden  
  
  // Anfang Attribute
  private static final int kbreite = 20;                //Gre des Gitternetzes
  private static final int xmax = 20;
  private static final int ymax = 20;
  private String bildname;
  private Image grafik;
  private int xPos=5;
  private int yPos=5;
  
  // Ende Attribute
  
  // Anfang Methoden
  public AutoCanvas() {       //Konstruktor
    super(null);              //bernahme des Konstruktors von der Oberklasse Canvas
    addKeyListener(this);     //Das Gitternetz hrt sich selbst zu und reagiert auf Tastendruck 
    addMouseListener(new MouseAdapter() {
          public void mousePressed(MouseEvent e) {
            requestFocus();
          }
      });
    
  }
  //Zeichnen des Gitternetzes
  public void paint(Graphics g) {                      
    g.setColor(Color.white);
    g.fillRect(0, 0, xmax*kbreite, ymax*kbreite);
    
    g.setColor(Color.black);
    for (int i = 0; i <= xmax; i++) {
      g.drawLine(i * kbreite, 0, i * kbreite, ymax * kbreite);
    }
    for (int j = 0; j <= ymax; j++) {
      g.drawLine(0, j * kbreite, xmax * kbreite, j * kbreite);
    }
  }
  //Zeichnen des Autos
  private void zeichneAuto(Graphics g, int x, int y,Image bild) {
    g.drawImage(bild, x * kbreite + 1, y * kbreite + 1,
    kbreite - 1, kbreite - 1, this);
  }
  public void zeichne(int x, int y) {
    Graphics g = getGraphics();
    bildname = "auto1.gif";
    grafik = new ImageIcon(getClass().getResource(bildname)).getImage();
    zeichneAuto(g,x,y,grafik);
  }
  //METHODEN ZUR STEUERUNG MIT DEN PFEILTASTEN  (berschreiben der Methoden des KeyListeners)
  
  //Diese Methode wird ausgefhrt, wenn eine Taste gedrckt wird.
  public void keyPressed (KeyEvent e) {
    //Jeder Taste ist eine Zahl zugeordnet, diese kann ber den KeyCode ausgelesen 
    //werden. Wenn dieser mit dem Pfeil nach unten bereinstimmt, dann...
    
    if (e.getKeyCode()==KeyEvent.VK_DOWN) {
      //hier muss stehen, was dann passieren soll
      //Pfeiltaste nach unten = y muss um ein Kstchen nach unten gesetzt werden
      yPos = yPos + 1;
      zeichne(xPos,yPos);
    } // end of if
    if (e.getKeyCode()==KeyEvent.VK_UP) {
      //Pfeiltaste nach oben = y muss um ein Kstchen nach oben gesetzt werden
      yPos = yPos - 1;
      zeichne(xPos,yPos);
    } // end of if
    if (e.getKeyCode()==KeyEvent.VK_LEFT) {
      //was soll passieren, wenn der Pfeil nach links gedrckt wird.
      xPos = xPos - 1;
      zeichne(xPos,yPos);
    } // end of if
    if (e.getKeyCode()==KeyEvent.VK_RIGHT) {
      //was soll passieren, wenn der Pfeil nach rechts gedrckt wird.
      xPos = xPos + 1;
      zeichne(xPos,yPos);
    } // end of if
  }
  //Diese Methode wird ausgefhrt, wenn eine Taste losgelassen wird.  
  public void keyReleased (KeyEvent e) {
    //Bei dieser Anwendung nicht ntig
  }
  //Diese Methode wird ausgefhrt, wenn eine Taste getippt wird. 
  //Diese Methode wird bentigt, wenn Tasten verwendet werden sollen, die nicht
  //auf der Standard-Englisch-Tastatur vorhanden sind. Brauchen wir also nicht!
  public void keyTyped (KeyEvent e) {
    //Bei dieser Anwendung nicht ntig
  }
  
  public void setXPos(int xPos) {
    this.xPos = xPos;
  }
  
  public void setYPos(int yPos) {
    this.yPos = yPos;
  }
  
  // Ende Methoden
} //Ende der Klasse