/**
  *
  * Beschreibung: Das Kochbuch wird als Liste abgespeichert. So kann es unbegrenzt
  *               erweitert werden
  * @version 1.0 vom 19.12.2014
  * @author Alexandra Horn
  */

public class Kochbuch {
  
  // Anfang Attribute
  public Rezept erstes;
  public Rezept letztes;
  public int anzahl;
  // Ende Attribute
  
  // Anfang Methoden
  public Kochbuch(){      //Konstruktor eines leeren Kochbuchs
    erstes = null;
    letztes = null;
    anzahl = 0;
  }
  //Fgt am Ende ein neues Rezept ein
  public void einfuegen(Rezept R) {
    if (letztes != null) letztes.setNachfolger(R);     //neues Rezept wird hinten angefgt, 
    //bisher letztes Rezept erhlt als
    //Nachfolger das neue Rezept
    else erstes = R;  //oder ist das erste Rezept
    letztes = R;        //auf jeden Fall ist das neue Rezept nun das letzte Rezept
    anzahl++;           //ein Rezept mehr als vorher
    R.setNummer(anzahl);//Nummer an Rezept bergeben
  }           
  
  public Rezept getErstes() {
    return erstes;
  }

  
  
  public void setErstes(Rezept erstes) {
    this.erstes = erstes;
  }

  public Rezept getLetztes() {
    return letztes;
  }

  public void setLetztes(Rezept letztes) {
    this.letztes = letztes;
  }

  public int getAnzahl() {
    return anzahl;
  }

  // Ende Methoden
} // end of Kochbuch

