import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  *
  * Beschreibung: Erzeugt ein Kochbuch und kann einzelne Rezepte ausgeben
  *
  * @version 1.0 vom 19.12.2014
  * @author Alexandra Horn
  */

public class KochbuchGUI extends JFrame {
  // Anfang Attribute
  private JLabel jLabel1 = new JLabel();
  private JLabel jLabel2 = new JLabel();
  private JLabel jLabel3 = new JLabel();
  private JLabel jLabel4 = new JLabel();
  private JTextArea jTAzutaten = new JTextArea("");
  private JScrollPane jTAzutatenScrollPane = new JScrollPane(jTAzutaten);
  private JTextArea jTAanleitung = new JTextArea("");
  private JScrollPane jTAanleitungScrollPane = new JScrollPane(jTAanleitung);
  private JNumberField jNFrezeptnr = new JNumberField();
  private JButton jBukochbuch = new JButton();
  private JButton jBuauswahl = new JButton();
  private JTextArea jTAhilfe = new JTextArea("");
  private JScrollPane jTAhilfeScrollPane = new JScrollPane(jTAhilfe);
  private JLabel jLabel5 = new JLabel();
  //Verbindungen zu den anderen Klassen
  private Kochbuch kochbuch = new Kochbuch();
  private Mengenangabe menge1, menge2, menge3, menge4, menge5;
  private Zutat zutat1, zutat2, zutat3, zutat4, zutat5, zutat6, zutat7, zutat8;
  private Rezept rezept1, rezept2, rezept3, rezept4, rezept5;
  // Ende Attribute
  
  public KochbuchGUI(String title) { 
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 1295; 
    int frameHeight = 614;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten    
    jLabel1.setBounds(0, 8, 1283, 97);
    jLabel1.setText("Kochbuch");
    jLabel1.setFont(new Font("LetterOMatic!", Font.BOLD, 24));
    jLabel1.setHorizontalTextPosition(SwingConstants.CENTER);
    jLabel1.setHorizontalAlignment(SwingConstants.CENTER);
    jLabel1.setBackground(Color.GRAY);
    jLabel1.setOpaque(true);
    cp.add(jLabel1);
    jLabel2.setBounds(768, 200, 219, 57);
    jLabel2.setText("Rezeptnummer:");
    jLabel2.setBackground(new Color(0xC0C0C0));
    jLabel2.setOpaque(true);
    jLabel2.setFont(new Font("LetterOMatic!", Font.BOLD, 20));
    cp.add(jLabel2);
    jLabel3.setBounds(312, 112, 419, 57);
    jLabel3.setText("Kochanleitung:");
    jLabel3.setBackground(new Color(0xC0C0C0));
    jLabel3.setOpaque(true);
    jLabel3.setFont(new Font("LetterOMatic!", Font.BOLD, 20));
    cp.add(jLabel3);
    jLabel4.setBounds(0, 112, 276, 57);
    jLabel4.setText("bentigte Zutaten:");
    jLabel4.setBackground(new Color(0xC0C0C0));
    jLabel4.setOpaque(true);
    jLabel4.setFont(new Font("LetterOMatic!", Font.BOLD, 20));
    cp.add(jLabel4);
    jTAzutatenScrollPane.setBounds(0, 168, 281, 345);
    cp.add(jTAzutatenScrollPane);
    jTAanleitungScrollPane.setBounds(312, 168, 417, 337);
    cp.add(jTAanleitungScrollPane);
    jNFrezeptnr.setBounds(992, 200, 49, 57);
    jNFrezeptnr.setText("");
    cp.add(jNFrezeptnr);
    jBukochbuch.setBounds(768, 272, 313, 65);
    jBukochbuch.setText("Kochbuch laden");
    jBukochbuch.setMargin(new Insets(2, 2, 2, 2));
    jBukochbuch.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBukochbuch_ActionPerformed(evt);
      }
    });
    jBukochbuch.setBackground(new Color(0xC0C0C0));
    jBukochbuch.setFont(new Font("LetterOMatic!", Font.BOLD, 20));
    
    cp.add(jBukochbuch);
    cp.setBackground(new Color(0xB8CFE5));
    jBuauswahl.setBounds(768, 128, 313, 65);
    jBuauswahl.setText("Rezept auswhlen ");
    jBuauswahl.setMargin(new Insets(2, 2, 2, 2));
    jBuauswahl.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBuauswahl_ActionPerformed(evt);
      }
    });
    jBuauswahl.setBackground(new Color(0xC0C0C0));
    
    jBuauswahl.setFont(new Font("LetterOMatic!", Font.BOLD, 20));
    cp.add(jBuauswahl);
    jTAhilfeScrollPane.setBounds(760, 384, 497, 121);
    jTAhilfe.setText("Zunchst muss ein Kochbuch geladen werden.");
    cp.add(jTAhilfeScrollPane);
    jLabel5.setBounds(760, 352, 371, 33);
    jLabel5.setText("Bedienhilfen");
    cp.add(jLabel5);
    // Ende Komponenten
    
    setVisible(true);
  } // end of public KochbuchGUI
  
  // Anfang Methoden
  //Testkochbuch erzeugen
  public void zutatenErzeugen() {     
    //Verschiedene Mengenangaben zufllig erzeugen
    menge1 = new Mengenangabe((int)(Math.random()*100),"g");        
    menge2 = new Mengenangabe((int)(Math.random()*10+1),"Teelffel");
    menge3 = new Mengenangabe((int)(Math.random()*100),"g");
    menge4 = new Mengenangabe((int)(Math.random()*50),"ml");
    menge5 = new Mengenangabe((int)(Math.random()*100),"g");
    //verschiedene Zutaten erzeugen
    zutat1 = new Zutat("Spagetti", menge1);
    zutat2 = new Zutat("Trffel",menge2);
    zutat3 = new Zutat("Schnitzel",menge3);
    zutat4 = new Zutat("Erbsen",menge3);
    zutat5 = new Zutat("Kartoffel",menge5);
    zutat6 = new Zutat("Spinat",menge3);
    zutat7 = new Zutat("Milch",menge4);
    zutat8 = new Zutat("Salz",menge2);        
  }
  //Zutaten den Rezepten hinzufgen und unsinnige Anleitung hinzufgen
  public void rezepteErzeugen() {
    zutatenErzeugen();
    rezept1 = new Rezept();
    rezept2 = new Rezept();
    rezept3 = new Rezept();
    rezept4 = new Rezept();
    rezept5 = new Rezept();
    rezept1.zutatHinzufuegen(zutat1);
    rezept1.zutatHinzufuegen(zutat2);
    rezept2.zutatHinzufuegen(zutat3);
    rezept2.zutatHinzufuegen(zutat4);
    rezept3.zutatHinzufuegen(zutat1);
    rezept3.zutatHinzufuegen(zutat5);
    rezept3.zutatHinzufuegen(zutat6);
    rezept4.zutatHinzufuegen(zutat3);
    rezept4.zutatHinzufuegen(zutat7);
    rezept4.zutatHinzufuegen(zutat8);
    rezept5.zutatHinzufuegen(zutat3);
    rezept5.zutatHinzufuegen(zutat5);
    //Kochanleitung ergnzen
    String anleitung1 = "Wasche und schle ";
    String anleitung2 = "\nSchmeie alle Zutaten in einen Topf,\n \nstelle ihn in den Ofen bei 300C\n \n und warte 10 Min.";
    rezept1.setAnleitung(anleitung1 + zutat1.getName() +"\n"+ anleitung2);
    rezept2.setAnleitung(anleitung1 + zutat3.getName() +"\n"+anleitung2);
    rezept3.setAnleitung(anleitung1 + zutat1.getName() +"\n"+ anleitung2);
    rezept4.setAnleitung(anleitung1 + zutat3.getName() +"\n"+ anleitung2);
    rezept5.setAnleitung(anleitung1 + zutat5.getName() +"\n"+ anleitung2);
  }
  public void jBukochbuch_ActionPerformed(ActionEvent evt) {
    //Kochbuch mit fnf Rezepten erzeugen
    rezepteErzeugen();
    kochbuch.einfuegen(rezept1);
    kochbuch.einfuegen(rezept2);
    kochbuch.einfuegen(rezept3);
    kochbuch.einfuegen(rezept4);
    kochbuch.einfuegen(rezept5);
    jTAhilfe.setText("Das Kochbuch ist nun geladen. \n\nNach Eingabe einer Nummer kann nun ein Rezept angezeigt werden.");
  } // end of jBukochbuch_ActionPerformed
  
  public void jBuauswahl_ActionPerformed(ActionEvent evt) {
    //Leeren der Textfelder, falls noch ein anderes Rezept geladen war
    jTAzutaten.setText("");
    jTAanleitung.setText("");
    int rNr = jNFrezeptnr.getInt();
    while (rNr<0) { 
      jTAhilfe.setText("Bevor man sich ein Rezept anschauen\nkann, muss zunchst ein Kochbuch\ngeladen werden.");
      rNr = jNFrezeptnr.getInt(); 
    } // end of while
    while (rNr>kochbuch.anzahl) { 
      jTAhilfe.setText("Leider sind nicht so viele Rezepte vorhanden.");
      rNr = jNFrezeptnr.getInt(); 
    } // end of while
    jTAhilfe.setText("Das Rezept mit der Nummer "+rNr+" wird ausgegeben.");
    //Richtiges Rezept im Kochbuch suchen
    Rezept ausgabeRezept = new Rezept();
    if (rNr == rezept1.getNummer()) {
      ausgabeRezept = rezept1;
    } // end of if
    else {
      if (rNr == rezept2.getNummer()) {
        ausgabeRezept = rezept2;
      } // end of if
      else {
        if (rNr == rezept3.getNummer()) {
          ausgabeRezept = rezept3;
        } // end of if
        else {
          if (rNr == rezept4.getNummer()) {
            ausgabeRezept = rezept4;
          } // end of if
          else {
            ausgabeRezept = rezept5;
          } // end of if-else
        } // end of if-else
      } // end of if-else
    } // end of if-else
    //Zutatenliste ausgeben
    int i = 0;
    while (ausgabeRezept.getZutatenliste()[i]!=null) { 
      Mengenangabe menge = ausgabeRezept.getZutatenliste()[i].getMenge();
      //append fgt am Ende des Textes den Text hinzu
      jTAzutaten.append(ausgabeRezept.getZutatenliste()[i].getName()+ " " + menge.getZahl()+" "+menge.getEinheit()+"\n");
      i++;
    } // end of while
    //Anleitung ausgeben
    jTAanleitung.setText(ausgabeRezept.getAnleitung());
    
  } // end of jBuauswahl_ActionPerformed
  
  // Ende Methoden
  
  public static void main(String[] args) {
    new KochbuchGUI("KochbuchGUI");
  } // end of main
  
} // end of class KochbuchGUI
